INSERT INTO EST_PROD_PRECO
(CD_EMP
, CD_FILIAL
, CD_CTR
, CD_PROD
, VLR_TABELA
, VLR_OFERTA
, DT_CAD
, CD_USU
, STS_PRECO
, VLR_CUSTO
, PERC_ICMS
, PERC_IMP
, PERC_COMIS
, PERC_DESP
, PERC_MARGEM
, STS_IMP_ETQ_GOND
, VLR_TABELA_ANT
, VLR_OFERTA_ANT
, VLR_CUSTO_GER
, ORIG_PRECO
)
SELECT P.CD_EMP
        , P.CD_FILIAL
        , 0 AS CD_CTR
        , P.CD_PROD
        , 0 AS VLR_TABELA
        , 0 AS VLR_OFERTA
        , CONVERT( CHAR(10), GETDATE(), 112) AS DT_CAD
        , 1 AS CD_USU
        , 0 AS STS_PRECO
        , 0 AS VLR_CUSTO
        , 0 AS PERC_ICMS
        , 0 AS PERC_IMP
        , 0 AS PERC_COMIS
        , 0 AS PERC_DESP
        , 0 AS PERC_MARGEM
        , 0 AS STS_IMP_ETQ_GOND
        , 0 AS VLR_TABELA_ANT
        , 0 AS VLR_OFERTA_ANT
        , 0 AS VLR_CUSTO_GER
        , 0 AS ORIG_PRECO
FROM
        EST_PROD_CPL P
        LEFT OUTER JOIN EST_PROD_PRECO
        ON P.CD_EMP = EST_PROD_PRECO.CD_EMP
        AND P.CD_FILIAL = EST_PROD_PRECO.CD_FILIAL
        AND P.CD_PROD = EST_PROD_PRECO.CD_PROD
        INNER JOIN EST_PROD
        ON P.CD_EMP = EST_PROD.CD_EMP
        AND P.CD_PROD = EST_PROD.CD_PROD
WHERE P.CD_EMP = 1
        AND EST_PROD_PRECO.CD_PROD IS NULL
        AND EST_PROD.STS_PROD IN(0, 2)